; shuffle.asm
extern printf
section .data					  
       
	fmt0	db "Liczby w pamięci: ",10,0 
	fmt00	db "Rejestr xmm0: ",10,0 
	fmt1 	db "%d ",0
	fmt2 	db "Tasowanie - dystrybucja podwójnego słowa %i:",10,0
	fmt3 	db "%d %d %d %d",10,0
  	fmt4 	db "Tasowanie - odwracanie podwójnego słowa:",10,0
	fmt5 	db "Tasowanie - odwracanie upakowanych bajtów w xmm0:",10,0
  	fmt6 	db "Tasowanie - rotacja w lewo:",10,0
	fmt7 	db "Tasowanie - rotacja w prawo:",10,0
	fmt8 	db "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",10,0
	fmt9 	db "Upakowane bajty w xmm0:",10,0
	NL  		db 10,0

	number1 	dd 1
	number2 	dd 2
  	number3 	dd 3
  	number4 	dd 4
        
	char 	db "abcdefghijklmnop"
	bytereverse db 15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0

section .bss
section .text							
	global main					
main:
push	rbp
mov	rbp,rsp
  	sub 	rsp,32   	      ; dla pierwotnej wartości xmm0
                 	          ; i zmodyfikowanej wartości xmm0
; TASOWANIE PODWÓJNYCH SŁÓW
; najpierw wypisujemy liczby w odwrotnej kolejności
	mov 	rdi, fmt0
	call	printf
	mov 	rdi, fmt1
	mov 	rsi, [number4]
	xor 	rax,rax
	call printf
	mov 	rdi, fmt1
	mov 	rsi, [number3]
	xor 	rax,rax
	call	printf
	mov 	rdi, fmt1
	mov 	rsi, [number2]
	xor 	rax,rax
	call	printf
	mov 	rdi, fmt1
	mov 	rsi, [number1]
	xor 	rax,rax
	call	printf
    mov 	rdi, NL
    call	printf

; wypełniamy xmm0 liczbami
	pxor 	xmm0,xmm0
	pinsrd 	xmm0, dword[number1],0
	pinsrd 	xmm0, dword[number2],1
	pinsrd 	xmm0, dword[number3],2
	pinsrd 	xmm0, dword[number4],3     
	movdqu 	[rbp-16],xmm0	; zapisujemy xmm0 do późniejszego użytku 
	mov 		rdi, fmt00
	call 	printf 		; wypisujemy tytuł
	movdqu 	xmm0,[rbp-16]	; przywracamy xmm0 po wywołaniu printf
	call 	print_xmm0d	; wypisujemy xmm0
	movdqu 	xmm0,[rbp-16]	; przywracamy xmm0 po wywołaniu printf
    
; TASOWANIE-DYSTRYBUCJA
; tasowanie: dystrybuujemy najmniej znaczące podwójne słowo (indeks 0)
		movdqu	xmm0,[rbp-16]      	; przywracamy xmm0
		pshufd 	xmm0,xmm0,00000000b	; tasujemy
    	mov 		rdi,fmt2
    	mov 		rsi, 0			; wypisujemy tytuł
    	movdqu 	[rbp-32],xmm0     	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]     	; przywracamy xmm0 po wywołaniu printf
    	call 	print_xmm0d        	; wypisujemy zawartość xmm0

; tasowanie: dystrybuujemy podwójne słowo o indeksie 1
    	movdqu 	xmm0,[rbp-16]      	; przywracamy xmm0 
    	pshufd 	xmm0,xmm0,01010101b	; tasujemy
    	mov 		rdi,fmt2
    	mov 		rsi, 1			; wypisujemy tytuł
    	movdqu 	[rbp-32],xmm0     	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]     	; przywracamy xmm0 po wywołaniu printf
    	call 	print_xmm0d        	; wypisujemy zawartość xmm0

; tasowanie: dystrybuujemy podwójne słowo o indeksie 2
    	movdqu 	xmm0,[rbp-16]     	; przywracamy xmm0
    	pshufd 	xmm0,xmm0,10101010b	; tasujemy
    	mov 		rdi,fmt2
		mov 		rsi, 2			; wypisujemy tytuł
    	movdqu 	[rbp-32],xmm0     	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]     	; przywracamy xmm0 po wywołaniu printf
    	call 	print_xmm0d        	; wypisujemy zawartość xmm0

; tasowanie: dystrybuujemy podwójne słowo o indeksie 3
    	movdqu 	xmm0,[rbp-16]      	; przywracamy xmm0
    	pshufd 	xmm0,xmm0,11111111b	; tasujemy
    	mov 		rdi,fmt2
    	mov 		rsi, 3			; wypisujemy tytuł
    	movdqu 	[rbp-32],xmm0     	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]     	; przywracamy xmm0 po wywołaniu printf
    	call 	print_xmm0d        	; wypisujemy zawartość xmm0     

; TASOWANIE-ODWRACANIE
; odwracanie podwójnych słów
    	movdqu 	xmm0,[rbp-16]     	; przywracamy xmm0
    	pshufd 	xmm0,xmm0,00011011b	; tasujemy
    	mov 	rdi,fmt4			; wypisujemy tytuł
		movdqu 	[rbp-32],xmm0      	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]      	; przywracamy xmm0 po wywołaniu printf
    	call 	print_xmm0d        	; wypisujemy zawartość xmm0

; TASOWANIE-ROTACJA
; rotacja w lewo
    	movdqu 	xmm0,[rbp-16]      	; przywracamy xmm0
    	pshufd 	xmm0,xmm0,10010011b	; tasujemy
    	mov 	rdi,fmt6			; wypisujemy tytuł
    	movdqu 	[rbp-32],xmm0     	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]     	; przywracamy xmm0 po wywołaniu printff
    	call 	print_xmm0d        	; wypisujemy zawartość xmm0

; rotacja w prawo
    	movdqu 	xmm0,[rbp-16]     	; przywracamy xmm0
    	pshufd 	xmm0,xmm0,00111001b	; tasujemy
    	mov 	rdi,fmt7			; wypisujemy tytuł
    	movdqu 	[rbp-32],xmm0      	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]      	; przywracamy xmm0 po wywołaniu printf
    	call 	print_xmm0d        	; wypisujemy zawartość xmm0

; TASOWANIE BAJTÓW
    	mov 	rdi, fmt9
    	call 	printf				; wypisujemy tytuł
    	movdqu 	xmm0,[char]			; wczytujemy znak do xmm0
    	movdqu 	[rbp-32],xmm0		; wywołanie printf niszczy xmm0
		push rbx
    	call 	print_xmm0b			; wypisujemy bajty w xmm0
    	pop rbx
		movdqu 	xmm0,[rbp-32]      	; przywracamy xmm0 po wywołaniu printf
    	movdqu 	xmm1,[bytereverse]	; wczytujemy maskę
    	pshufb 	xmm0,xmm1			; tasujemy bajty
    	mov 	rdi,fmt5			; wypisujemy tytuł
    	movdqu 	[rbp-32],xmm0     	; wywołanie printf niszczy xmm0
    	call 	printf
    	movdqu 	xmm0,[rbp-32]     	; przywracamy xmm0 po wywołaniu printf
    	push rbx
		call 	print_xmm0b        	; wypisujemy zawartość xmm0
		pop rbx
leave
ret
;funkcja do wypisywania podwójnych słów--------------------
print_xmm0d:
push	rbp		
mov	rbp,rsp
    	mov 		rdi, fmt3
    	xor 		rax,rax
    	pextrd 	esi, xmm0,3  	;wyodrębniamy podwójne słow
    	pextrd 	edx, xmm0,2	    ;w odwrotnej kolejności, little endian
    	pextrd 	ecx, xmm0,1
    	pextrd 	r8d, xmm0,0
    	call 	printf
leave
ret
;funkcja do wypisywania bajtów ---------------------------
print_xmm0b:
push	rbp		
mov	rbp,rsp
	mov 		rdi, fmt8
    	xor		rax,rax
    	pextrb 	esi, xmm0,0  	; w odwrotnej kolejności, little endian
    	pextrb 	edx, xmm0,1  	; najpierw używamy rejestrów,
    	pextrb 	ecx, xmm0,2	    ; a potem stosu
    	pextrb 	r8d, xmm0,3
    	pextrb 	r9d, xmm0,4
    	pextrb 	eax, xmm0,15
    	push 	rax
    	pextrb 	eax, xmm0,14
    	push 	rax
    	pextrb 	eax, xmm0,13
    	push 	rax
    	pextrb 	eax, xmm0,12
    	push 	rax 
    	pextrb 	eax, xmm0,11
    	push 	rax
    	pextrb 	eax, xmm0,10
    	push 	rax
    	pextrb 	eax, xmm0,9
    	push 	rax
    	pextrb 	eax, xmm0,8
    	push 	rax
    	pextrb 	eax, xmm0,7
    	push 	rax
    	pextrb 	eax, xmm0,6
		push 	rax
    	pextrb 	eax, xmm0,5
    	push 	rax  
    	xor 		rax,rax 
    	call 	printf
leave
ret



